#version 140
#extension GL_EXT_gpu_shader4 : enable
// Sacred WavesMod01.fsh by  xnio94
//https://www.shadertoy.com/view/stdXR2
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iGlobalTime u_Elapsed


#define iTime u_Elapsed*0.3090234
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )


//#define iChannel0 sampler2D
//#define iChannel1 sampler2D
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract



#define to 6.28
void main( void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    float t = iTime;
    vec2 p = uv + sin((length(uv-.5))*5.5-t);
    p = p * (sin(length(uv-.5)*to*2. - t*4.)+1.)/2.;
    float d = (sin(length(uv-.5)*to*5. - t) + 4.)*4. ;
    float col;
    col = length(p)/2.+sin(atan(p.y,p.x)*d)*atan(p.y,p.x)/4.;
    gl_FragColor = vec4(vec3(col,col/3.,0.),1.0);
}